<?php 
    /**
    *
    * copyright (c) 2013-2023 Heliac Technologies
    * license http://opensource.org/licenses/gpl-license.php GNU GPL v3 
    *
    * linee guida per l'utilizzo del logo http://www.geecom.org/index.php?alias=linee-guida-per-luso-del-logo-geecom
    */

    include "include/includeBase.php";
    
    include "include/controlloLogin.php";
    
    $analisiSito= calcoloStatoSito($impostazioni, $geecomDb);
?>
<!doctype html>
<html lang="en">
    <head>
        <!-- Required meta tags -->
        <meta charset="utf-8">
        <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">

        <?php
            include "include/cssBaseAreaAmministrativa.php";
        ?>
        <!-- Owl Carousel-->
        <link rel="stylesheet" href="../plugins/OwlCarousel2/assets/owl.carousel.min.css">

        <title>Geecom CMS - area amministrativa</title>
    </head>
  
    <body>
        <header>
            <?php 
                include "include/barraSuperiore.php";

                include "include/header.php";

                include "include/barraMenu.php";
            ?>
        </header>

        <main role="main" class="bg-light" id="main">
            <div id="dashboard" class="container-fluid">
                <div class="row">
                    <!-- Colonna principale -->
                    <div class="col-12 py-4">
                        <?php 
                            if($impostazioni["mostraGuidaIniziale"]=="si") {
                                include "include/guidaIniziale.php";
                            }

                            include "include/cruscotto.php";
                            $parametri = array("tabella"=>"geecB_contenuti", "elementiPerPagina"=>10,"parametriRicerca"=>array(),"ajax"=>false);
                            $ricerca = new Ricerca($geecomDb, $parametri, $impostazioniRicerca, "");
                            $ricerca->setOrdinamento("ORDER BY numeroVisite DESC");
                        ?>
                        <div class="row my-4">
                        <?php
                            $queryCruscottiComponenti = "SELECT * FROM geecB_componenti WHERE tabellaRiassuntivaHome LIKE 'si' ORDER BY id DESC";
                            $risCruscotti             = $geecomDb->eseguiQueryLettura($queryCruscottiComponenti);
                            while($componenteConCruscotto = $risCruscotti->fetch_assoc()) {
                                include "componenti/{$componenteConCruscotto["paginaGestione"]}/tabellaRiassuntivaHome.php";
                            }
                        ?>
                        </div>
                    </div><!-- /Colonna principale -->
                </div>
            </div>
        </main>

        <?php 
            include "include/footer.php";

            include "include/modal/cambiaPassword.php";

            include "include/modal/modalMenuComponenti.php";

            include "include/modal/operazioneCompletata.php";

            include "include/jsBaseAreaAmministrativa.php";
        ?>
        
        <script src="../plugins/OwlCarousel2/owl.carousel.min.js"></script>
        <script type="text/javascript">
            $('#slider-benvenuto').owlCarousel({
                items:1,
                smartSpeed:500,
                margin: 30,
                nav: false,
                autoplay: true,
                autoplaySpeed:2000,
                autoplayHoverPause:true,
                responsive:{
                    0:{
                        items:1
                    },
                    1000:{
                        items:2
                    },
                    1600:{
                        items:3
                    }
                }
            });
            
            function attivaDisattivaTabellaRiassuntivaHome(idComponente) {
                var componente = document.getElementById("checboxMostraTabellaRiassuntiva"+idComponente);
                        
                if(componente.checked == true) {
                    var operazione = "attivaTabellaRiassuntivaHome";
                }
                else {
                    var operazione = "disattivaTabellaRiassuntivaHome";
                }
                
                $.ajax({
                    type:"POST",
                    url:"../controller/controllerImpostazioni.php",
                    data:{
                        operazione:operazione,
                        idComponente:idComponente
                    },
                    success:function(esito) {
                        if(esito==="ok") {
                            location.href = "home.php?gestisciComponenti=si";
                        }
                    },
                    error: function(xhr,status,error) {
                        alert(status+" "+error);
                    }
                });
            }
            
            function modificaClasseElementiStatisticiPerRigaHomeAdmin() {
                var classeElementiStatistici = document.getElementById("classeElementiStatistici").value;
                        
                $.ajax({
                    type:"POST",
                    url:"../controller/controllerImpostazioni.php",
                    data:{
                        operazione:"modificaClasseElementiStatisticiPerRigaHomeAdmin",
                        classeElementiStatistici:classeElementiStatistici
                    },
                    success:function(esito) {
                        if(esito==="ok") {
                            location.href = "home.php?gestisciComponenti=si";
                        }
                    },
                    error: function(xhr,status,error) {
                        alert(status+" "+error);
                    }
                });
            }
        </script>
    </body>
</html>